CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE lower(TABLE_NAME) = 'est_nf_ent_danfe_provisorio') THEN 
        create table est_nf_ent_danfe_provisorio (
		cd_ctr bigint not null ,
		cd_ctr_it int not null,
		cd_emp int not null ,
		cd_filial int not null ,
		dt_emis_nf date not null,
		nr_autorizador varchar(150) not null,
		cd_prod int not null,
		cd_barra varchar(20),
		nr_lote varchar(50),
		qtde_prod numeric(15,2) not null,
		dt_valid date,
		dt_fabric date,
		CONSTRAINT pk_est_nf_ent_danfe_provisorio primary key (cd_ctr, cd_ctr_it)
	)
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA est_nf_ent_danfe_provisorio %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();

